<?php
/**
 * Post Unsubscribe Page Template
 *
 * @var string $site_name Site name
 * @var string $site_url  Site URL
 * @var bool   $success   Whether unsubscribe succeeded
 * @var string $message   Message to display
 * @var string $icon      SVG icon HTML
 * @var string $title     Page title
 */

defined('ABSPATH') || exit;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo esc_html($title); ?> - <?php echo esc_html($site_name); ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            padding: 48px;
            text-align: center;
            max-width: 440px;
            width: 100%;
        }
        .icon { margin-bottom: 24px; }
        h1 {
            font-size: 24px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 12px;
        }
        p {
            color: #64748b;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 24px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #6366f1;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 500;
            transition: background 0.2s;
        }
        .btn:hover { background: #4f46e5; }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon"><?php echo $icon; ?></div>
        <h1><?php echo esc_html($title); ?></h1>
        <p><?php echo esc_html($message); ?></p>
        <a href="<?php echo esc_url($site_url); ?>" class="btn">Return to <?php echo esc_html($site_name); ?></a>
    </div>
</body>
</html>
