<?php
/**
 * Email Confirmation Page Template
 *
 * @var string $siteName   Site name (escaped)
 * @var string $siteUrl    Site URL (escaped)
 * @var bool   $success    Whether confirmation succeeded
 * @var string $message    Main message (escaped)
 * @var string $iconColor  Icon color hex
 * @var string $iconPath   SVG path for icon
 * @var string $subMessage Sub-message text (escaped)
 */

defined('ABSPATH') || exit;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Confirmation - <?php echo $siteName; ?></title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            padding: 48px;
            max-width: 450px;
            width: 100%;
            text-align: center;
        }
        .icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 24px;
        }
        .icon svg {
            width: 100%;
            height: 100%;
        }
        h1 {
            font-size: 24px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 12px;
        }
        .message {
            font-size: 16px;
            color: #64748b;
            line-height: 1.6;
            margin-bottom: 32px;
        }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 12px 32px;
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            transition: transform 0.15s ease, box-shadow 0.15s ease;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -5px rgba(99, 102, 241, 0.4);
        }
        .site-name {
            margin-top: 32px;
            font-size: 14px;
            color: #94a3b8;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">
            <svg fill="none" stroke="<?php echo esc_attr($iconColor); ?>" viewBox="0 0 24 24" stroke-width="1.5">
                <path stroke-linecap="round" stroke-linejoin="round" d="<?php echo esc_attr($iconPath); ?>" />
            </svg>
        </div>
        <h1><?php echo $message; ?></h1>
        <p class="message">
            <?php echo $subMessage; ?>
        </p>
        <a href="<?php echo $siteUrl; ?>" class="btn">Visit <?php echo $siteName; ?></a>
        <p class="site-name"><?php echo $siteName; ?></p>
    </div>
</body>
</html>
