<?php
/**
 * Double Opt-In Confirmation Email Template
 *
 * @var string $siteName   Site name (escaped)
 * @var string $siteUrl    Site URL (escaped)
 * @var string $firstName  Subscriber first name (escaped)
 * @var string $confirmUrl Confirmation URL (escaped)
 * @var string $year       Current year
 */

defined('ABSPATH') || exit;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm your subscription</title>
</head>
<body style="margin: 0; padding: 0; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; background-color: #f8fafc;">
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background-color: #f8fafc;">
        <tr>
            <td align="center" style="padding: 48px 20px;">
                <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="max-width: 560px; background-color: #ffffff; border-radius: 12px; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);">
                    <!-- Header -->
                    <tr>
                        <td style="padding: 40px 40px 24px; text-align: center; border-bottom: 1px solid #e2e8f0;">
                            <h1 style="margin: 0; font-size: 24px; font-weight: 700; color: #1e293b;">
                                Confirm Your Subscription
                            </h1>
                        </td>
                    </tr>

                    <!-- Content -->
                    <tr>
                        <td style="padding: 32px 40px;">
                            <p style="margin: 0 0 20px; font-size: 16px; line-height: 1.6; color: #475569;">
                                Hi <?php echo $firstName; ?>,
                            </p>
                            <p style="margin: 0 0 20px; font-size: 16px; line-height: 1.6; color: #475569;">
                                Thanks for subscribing to <strong><?php echo $siteName; ?></strong>! Please click the button below to confirm your email address.
                            </p>
                            <p style="margin: 0 0 32px; font-size: 16px; line-height: 1.6; color: #475569;">
                                This link will expire in 48 hours.
                            </p>

                            <!-- Button -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td align="center">
                                        <a href="<?php echo $confirmUrl; ?>" style="display: inline-block; padding: 14px 32px; background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%); color: #ffffff; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: 600;">
                                            Confirm Email Address
                                        </a>
                                    </td>
                                </tr>
                            </table>

                            <p style="margin: 32px 0 0; font-size: 14px; line-height: 1.6; color: #64748b;">
                                If you didn't subscribe to <?php echo $siteName; ?>, you can safely ignore this email.
                            </p>
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td style="padding: 24px 40px; background-color: #f8fafc; border-top: 1px solid #e2e8f0; border-radius: 0 0 12px 12px;">
                            <p style="margin: 0 0 8px; font-size: 14px; color: #64748b; text-align: center;">
                                If the button doesn't work, copy and paste this link into your browser:
                            </p>
                            <p style="margin: 0; font-size: 12px; color: #94a3b8; text-align: center; word-break: break-all;">
                                <?php echo $confirmUrl; ?>
                            </p>
                        </td>
                    </tr>
                </table>

                <!-- Bottom text -->
                <p style="margin: 24px 0 0; font-size: 13px; color: #94a3b8; text-align: center;">
                    &copy; <?php echo $year; ?> <?php echo $siteName; ?>. All rights reserved.
                </p>
            </td>
        </tr>
    </table>
</body>
</html>
