<?php
/**
 * Admin Vue.js app container
 */

if (!defined('ABSPATH')) {
    exit;
}
?>
<div id="outreach-app" class="outreach-admin">
    <div class="outreach-loading">
        <svg class="outreach-loading__spinner" viewBox="0 0 50 50">
            <circle cx="25" cy="25" r="20" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round">
                <animate attributeName="stroke-dasharray" values="1, 150; 90, 150; 90, 150" dur="1.5s" repeatCount="indefinite"/>
                <animate attributeName="stroke-dashoffset" values="0; -35; -125" dur="1.5s" repeatCount="indefinite"/>
            </circle>
        </svg>
        <span><?php esc_html_e('Loading WP Outreach...', 'outreach'); ?></span>
    </div>
</div>

<style>
/* Hide WordPress notices on our page */
.outreach-admin ~ .notice,
.outreach-admin ~ .updated,
.outreach-admin ~ .error,
#wpbody-content > .notice,
#wpbody-content > .updated,
#wpbody-content > .error {
    display: none !important;
}

/* Full height container */
.outreach-admin {
    position: fixed;
    top: 32px; /* WP admin bar */
    left: 160px; /* WP sidebar */
    right: 0;
    bottom: 0;
    background: #f8fafc;
    z-index: 99;
}

@media screen and (max-width: 782px) {
    .outreach-admin {
        left: 0;
        top: 46px;
    }
}

/* Collapsed sidebar */
.folded .outreach-admin {
    left: 36px;
}

@media screen and (max-width: 960px) {
    .auto-fold .outreach-admin {
        left: 36px;
    }
}

@media screen and (max-width: 782px) {
    .auto-fold .outreach-admin,
    .folded .outreach-admin {
        left: 0;
    }
}

/* Loading state */
.outreach-loading {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
    gap: 16px;
    color: #64748b;
    font-size: 14px;
}

.outreach-loading__spinner {
    width: 40px;
    height: 40px;
    color: #6366f1;
    animation: outreach-rotate 2s linear infinite;
}

@keyframes outreach-rotate {
    100% {
        transform: rotate(360deg);
    }
}
</style>
