<?php
/**
 * Plugin Name: Outreach
 * Plugin URI: https://wpoutreach.com/
 * Description: Modern WordPress newsletter, autoresponder, and update notifier with a SaaS-like experience.
 * Version: 2.6.7
 * Author: codename065
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: outreach
 * Domain Path: /languages
 * Requires at least: 6.0
 * Requires PHP: 8.0
 */

namespace WPOutreach;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('WP_OUTREACH_VERSION', '2.6.7');
define('WP_OUTREACH_FILE', __FILE__);
define('WP_OUTREACH_PATH', plugin_dir_path(__FILE__));
define('WP_OUTREACH_URL', plugin_dir_url(__FILE__));
define('WP_OUTREACH_BASENAME', plugin_basename(__FILE__));
define('WP_OUTREACH_DOWNLOAD_URL', 'https://wpoutreach.com/?wpdmdl=148');
// Autoloader
if (file_exists(WP_OUTREACH_PATH . 'vendor/autoload.php')) {
    require_once WP_OUTREACH_PATH . 'vendor/autoload.php';
}

/**
 * Initialize the plugin
 */
function wp_outreach_init() {
    // Check PHP version
    if (version_compare(PHP_VERSION, '8.0', '<')) {
        add_action('admin_notices', function() {
            echo '<div class="notice notice-error"><p>';
            echo esc_html__('WP Outreach requires PHP 8.0 or higher.', 'outreach');
            echo '</p></div>';
        });
        return;
    }

    // Boot the plugin
    $bootstrap = new Bootstrap();
    $bootstrap->init();
}

add_action('plugins_loaded', __NAMESPACE__ . '\\wp_outreach_init');

/**
 * Activation hook
 */
register_activation_hook(__FILE__, function() {
    require_once WP_OUTREACH_PATH . 'includes/Activator.php';
    Activator::activate();
});

/**
 * Deactivation hook
 */
register_deactivation_hook(__FILE__, function() {
    require_once WP_OUTREACH_PATH . 'includes/Deactivator.php';
    Deactivator::deactivate();
});
