<?php

namespace WPOutreach\Mailer;

/**
 * WordPress wp_mail() based mailer
 */
class WPMailer extends AbstractMailer
{
    /**
     * Get mailer name
     */
    public function getName(): string
    {
        return 'wp_mail';
    }

    /**
     * Check if configured (always true for wp_mail)
     */
    public function isConfigured(): bool
    {
        return true;
    }

    /**
     * Send email using wp_mail()
     */
    public function send(string $to, string $subject, string $body, array $options = []): bool
    {
        $this->clearError();

        $options = $this->mergeOptions($options);
        $headers = $this->buildHeaders($options);
        $body = $this->wrapHtml($body);

        // Attachments
        $attachments = $options['attachments'] ?? [];

        // Capture wp_mail errors
        $error_message = null;
        $error_handler = function ($wp_error) use (&$error_message) {
            $error_message = $wp_error->get_error_message();
        };

        add_action('wp_mail_failed', $error_handler);

        $result = wp_mail($to, $subject, $body, $headers, $attachments);

        remove_action('wp_mail_failed', $error_handler);

        if (!$result && $error_message) {
            $this->setError($error_message);
        } elseif (!$result) {
            $this->setError(__('Failed to send email via wp_mail()', 'outreach'));
        }

        return $result;
    }
}
