<?php

namespace WPOutreach\Mailer;

/**
 * Interface for all email mailers
 */
interface MailerInterface
{
    /**
     * Send an email
     *
     * @param string $to Recipient email address
     * @param string $subject Email subject
     * @param string $body Email body (HTML)
     * @param array $options Additional options (from_name, from_email, reply_to, headers, attachments)
     * @return bool True on success, false on failure
     */
    public function send(string $to, string $subject, string $body, array $options = []): bool;

    /**
     * Send email to multiple recipients
     *
     * @param array $recipients Array of email addresses
     * @param string $subject Email subject
     * @param string $body Email body (HTML)
     * @param array $options Additional options
     * @return array Results keyed by email address ['email@example.com' => true/false]
     */
    public function sendBatch(array $recipients, string $subject, string $body, array $options = []): array;

    /**
     * Get the last error message
     *
     * @return string|null
     */
    public function getLastError(): ?string;

    /**
     * Check if the mailer is properly configured
     *
     * @return bool
     */
    public function isConfigured(): bool;

    /**
     * Get mailer name/identifier
     *
     * @return string
     */
    public function getName(): string;
}
