<?php

namespace WPOutreach\Integrations\Forms;

/**
 * Form Integrations Loader
 *
 * Initializes all form plugin integrations for WP Outreach automation triggers.
 * Each integration registers its triggers and hooks into the form submission process.
 *
 * Supported form plugins:
 * - Contact Form 7
 * - WPForms
 * - Gravity Forms
 * - WooCommerce (checkout as form)
 *
 * @since 1.3.0
 */
class FormIntegrationsLoader
{
    /**
     * Initialize all form integrations
     */
    public static function init(): void
    {
        // Load Contact Form 7 integration
        ContactForm7Integration::init();

        // Load WPForms integration
        WPFormsIntegration::init();

        // Load Gravity Forms integration
        GravityFormsIntegration::init();

        // Load WooCommerce checkout integration
        WooCommerceIntegration::init();
    }
}
